(
	-- Color Correction Texture: FULL IMPLEMENTATION

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"85518d3a-34a4-4967-9296-c279811bbf80" 
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			local out = "result"
			if (context == 1) do out = "normalPerturb" -- bump mode

			if (mtl.map != undefined) do
			(
				append res #("input",     mtl.map, out) 
				append res #("alpha",     mtl.map, "alpha") 
			)

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #("input",     mtl.color) 
			append res #("alpha",     mtl.color.a/255.0) 

			append res #("RewireR", mtl.rewireR) 
			append res #("RewireG", mtl.rewireG) 
			append res #("RewireB", mtl.rewireB) 
			append res #("RewireA", mtl.rewireA) 

			append res #("hueShift", mtl.hueShift / 360.0) 
			append res #("saturation", 1.0 + (mtl.saturation / 100.0)) 

			append res #("tintHue", mtl.tint.h / 255.0)
			append res #("tintStrength", mtl.tintStrength / 100.0)  

			if (mtl.lightnessmode == 0) then
			(
				-- Regular mode

				local gain = 1.0 + mtl.contrast / 100.0;
				local lift = (mtl.brightness / 100.0) - 0.5 * (gain - 1.0)

				append res #("gainRGB", gain )
				append res #("liftRGB", lift )
				append res #("gammaRGB", 1.0 )
				append res #("pivotRGB", 1.0 )
				append res #("EnableR", false )
				append res #("EnableG", false )
				append res #("EnableB", false )
			)
			else
			(
				local gain = 1.0
				local lift = 0.0

				-- Gain math for Global
				gain = mtl.gainRGB / 100.0
				if (mtl.exposureMode == 1) do gain = pow 2.0 gain
				if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
				append res #("gainRGB", gain )
				append res #("liftRGB", mtl.liftRGB)
				append res #("gammaRGB", 1.0 / mtl.gammaRGB )
				append res #("pivotRGB", mtl.pivotRGB )

				if (mtl.EnableR) do (
					-- Gain math for red override
					gain = mtl.gainR / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainR", gain )
					append res #("liftR", mtl.liftR )
					append res #("gammaR", 1.0 / mtl.gammaR )
					append res #("pivotR", mtl.pivotR )
				)

				if (mtl.EnableG) do (
					-- Gain math for green override
					gain = mtl.gainG / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainG", gain )
					append res #("liftG", mtl.liftG )
					append res #("gammaG", 1.0 / mtl.gammaG )
					append res #("pivotG", mtl.pivotG )
				)

				if (mtl.EnableB) do (
					-- Gain math for blue override
					gain = mtl.gainB / 100.0
					if (mtl.exposureMode == 1) do gain = pow 2.0 gain
					if (mtl.exposureMode == 2) do gain = pow mtl.printerLights gain
					append res #("gainB", gain )
					append res #("liftB", mtl.liftB )
					append res #("gammaB", 1.0 / mtl.gammaB )
					append res #("pivotB", mtl.pivotB )
				)

				append res #("EnableR", mtl.EnableR)
				append res #("EnableG", mtl.EnableG)
				append res #("EnableB", mtl.EnableB)
			)			

 			res
		)
	)

	AMGData()
)
-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBDlZwWc7RYaFJGt6qbP47DmRdMv86cowh7
-- nM8ZA63OdZzYJL5K4uQFlWeqlqGkRIUfQsPdXIvKMhfjr1piAxOTO56W/Ey6wKPU
-- 3cCZdP5wLcGDYc8WDKAFY4Z8RDZ6aAeCaxYS5Mnl70q37jAmgwZKydFScD29Sntj
-- 7I2xQZw+gYQaLMzdVVzSycoWnchjG76+8t5qRcyzkZtL/X+1he+Z2m8nKSizELeJ
-- +Sjk8ATkuD7lQv+Sm6Kw2y97aXr5hbsZYX8BLc+9qvUVlkOjNfI1lw+CRbrvChaN
-- 811BX2ACZSCfX6kce3IMefPXFmH54vJibY70PBbtbNpysgYB3+3F
-- -----END-SIGNATURE-----